<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class JobQuestion extends Model
{
    protected $table = 'job_questions';
    protected $primaryKey = 'Question_id';
    public $timestamps = true;

    protected $fillable = [
        'Job_id',
        'Question_text',
        'Question_type',
        'Options',
        'Order',
        'Is_required',
        'Max_length',
        'Min_value',
        'Max_value',
        'Validation_rules',
        'Weight',
    ];

    protected $casts = [
        'Question_type' => 'string',
        'Options' => 'array',
        'Order' => 'integer',
        'Is_required' => 'boolean',
        'Max_length' => 'integer',
        'Min_value' => 'integer',
        'Max_value' => 'integer',
        'Validation_rules' => 'array',
        'Weight' => 'decimal:2',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function job()
    {
        return $this->belongsTo(Job::class, 'Job_id', 'Job_id');
    }
}
